#if defined _WIN32

#include<windows.h>
#include<stdio.h>

DWORD WINAPI thread_func(void *arg) {
    printf("Printing from a thread.\n");
    return 0;
}

int main(void) {
    DWORD id;
    HANDLE th;
    printf("Starting thread.\n");
    th = CreateThread(NULL, 0, thread_func, NULL, 0, &id);
    WaitForSingleObject(th, INFINITE);
    printf("Stopped thread.\n");
    return 0;
}
#else

#include<pthread.h>
#include<stdio.h>

#ifdef HAVE_UNUSED
    #define UNUSED_ATTR __attribute__((unused))
#else
    #define UNUSED_ATTR
#endif

void* main_func(void UNUSED_ATTR *arg) {
    printf("Printing from a thread.\n");
    return NULL;
}

int main(void) {
    pthread_t thread;
    int rc;
    printf("Starting thread.\n");
    rc = pthread_create(&thread, NULL, main_func, NULL);
    rc = pthread_join(thread, NULL);
    printf("Stopped thread.\n");
    return rc;
}

#endif
